<?php

$this->pageTitle = 'Zarządzanie rozwiązanymi zleceniami - '.Yii::app()->name;

$this->breadcrumbs = array(
	'Zlecenia'=>array('admin'),
	'Zarządzanie rozwiązanymi zleceniami',
);

$cs = Yii::app()->clientScript;
$cs->registerCoreScript('jquery');
$cs->registerCoreScript('jquery.ui');
$cs->registerCssFile(Yii::app()->baseUrl.'/css/ui/themes/smoothness/jquery-ui.min.css');
$cs->registerScriptFile($this->module->assetsUrl . '/js/accordion.js', CClientScript::POS_HEAD);

?>
<h1>Zarządzanie rozwiązanymi zleceniami</h1>

<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'zlecenie-firmy-form',
	'enableAjaxValidation'=>false,
)); ?>

<?php if($error): ?>
<div class="errorSummary">
	<p>
		Błąd.
	</p>
</div>
<?php endif; ?>

<?php if(Yii::app()->user->hasFlash('success')): ?>
<div class="flash-success">
	<?php echo Yii::app()->user->getFlash('success'); ?>
</div>
<?php endif; ?>

<div class="row">
	<?php //echo CHtml::label('Waga zleceń łatwych', 'easyWeight'); ?>
	<?php //echo CHtml::textField('easyWeight', $parameters['ZLECENIE_CENA_WAGA_LATWE']->wartosc); ?>

	<div class="col buttons">
		<?php //echo CHtml::submitButton('Zapisz', array('class'=>'buttonS bBlue')); ?>
	</div>
</div>

<?php $this->endWidget(); ?>

<style>
	.fail {
		font-weight: bold;
		color: red;
	}
	.success {
		font-weight: bold;
		color: blue;
	}
	div[header-id] {
		font-weight: bold;
		cursor: pointer;
	}
	div[tresc-id] h1 {
		text-align:center;
	}
	div[tresc-id] img {
		max-width:80%;
	}
/*	#uzytkownik-zlecenia-lista a:hover {
		font-weight: initial;
	}*/
	#printAll, .taskOrderUpdate {
		cursor: pointer;
	}
	.pleaseCenterAlignThisColumnForMe {
		text-align: center
	}
	.orderListGroup
	{
		border: 1px solid #DDDCDC;
		border-radius: 5px;
		padding: 10px;
		margin-bottom: 10px;
		position: relative;
	}
	.orderListGroup legend {
		margin-left: 5px;
		font-weight: bold;
	}
	div.ui-datepicker.ui-widget.ui-widget-content a:hover {
		font-weight: initial
	}
	.buttonS.bDefault
	{
		color: #000;
		margin-bottom: 5px;
	}
</style>

<p>
<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('/administration/szkolenie/reportedExams') ?>">Zarządzaj egzaminami</a>
<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('reportedAuctions') ?>">Zarządzaj przetargami</a>
</p>
<h2>Zlecenia zgłoszone przez uczniów</h2>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'uzytkownik-zlecenia-zgloszone-lista',
	'dataProvider'=> new CArrayDataProvider($zgloszone),
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'header'=>'Id zlecenia',
			'name'=>'zlecenie',
			'type'=>'raw',
//			'value'=>'$data->idZlecenia'
			'value'=>'"<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/update", array("id"=>$data->idZlecenia)) . "\">$data->idZlecenia</a>"'
		),
		array(
			'header'=>'Dziedzina',
			'name'=>'dziedzina',
			'value'=>'"<img title=\"" . $data->idZlecenia0->dziedzina->nazwa . "\" alt=\"" . $data->idZlecenia0->dziedzina->nazwa .
				"\" src=\"" . $data->idZlecenia0->dziedzina->namesAsImageUrl . "\" />"',
			'type'=>'raw'
		),
		array(
			'header'=>'Kategoria',
			'name'=>'kategoria',
			'value'=>'$data->idZlecenia0->kategoria',
		),
		array(
			'header'=>'Poziom',
			'name'=>'poziom',
			'value'=>'$data->idZlecenia0->poziomStr',
		),
		array(
			'header'=>'Data zakończenia',
			'name'=>'czasZakonczenia',
			'value'=>'$data->czasZakonczenia',
		),
		array(
			'header'=>'Użytkownik',
			'name'=>'user',
			'value'=>'$data->uczen["imie"]. " " .$data->uczen["nazwisko"]',
		),
		array(
			'header'=>'Firma',
			'name'=>'firma',
			'value'=>'$data->idFirmy0["nazwa"]',
		),
		array(
			'header'=>'Akcje',
			'value'=>'"<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/ignoreReportedSolution", array("id"=>$data->id)) . "\" class=\"buttonS bDefault\">Ignoruj</a><br/>
				<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/resetReportedSolution", array("id"=>$data->id)) . "\" class=\"buttonS bDefault\">Zresetuj zadanie</a><br/>
				<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/acceptReportedSolution", array("id"=>$data->id)) . "\" class=\"buttonS bDefault\">Uznaj odpowiedź</a>
</td></tr><tr><td colspan=\"9\"><div header-id=\"" . $data->id ."\">Szczegóły</div><div tresc-id=\"" . $data->id ."\">" .
				(empty($data->idZlecenia0->urlObrazka) ? "" :
				"<h1><img src=\"" . Yii::app()->baseUrl."/".$data->idZlecenia0->urlObrazka . "\"/></h1>") .
				"<p>" . $data->idZlecenia0->tresc . "</p>
				<div><u>Odpowiedzi</u>: " . implode(", ", array_values(CHtml::listData($data->idZlecenia0->odpowiedziZlecenia, "id", "odpowiedz"))) . "</div>
				<div><u>Udzielona odpowiedź</u>: <i>" . ($data->odpowiedz == null ? "brak odpowiedzi" : $data->odpowiedz) .
					($data->idZlecenia0->jednostka==null?"":" [".$data->idZlecenia0->jednostka."]") . "</i></div>
				<br/>
				<div><u>Uczeń</u>: ".$data->uczen->imie." ".$data->uczen->nazwisko."</div>
				<div><u>Szkoła</u>: ". $data->uczen->klasa->szkola["nazwa"]."</div>
				<div><u>Klasa</u>: ". $data->uczen->klasa["nazwa"]."</div>
				</div></td></tr>
				"',
			'type'=>'raw'
		),
	),
));
?>
<br/><br/>

<?php // narazie bez tego bo jest problematyczne ?>
<?php /* ?>
<h2>Pozostałe rozwiązane zlecenia</h2>
<?php foreach($rozwiazane as $indx => $rozw): ?>
<h3 style="margin-top: 10px">Klasa: <?php echo $indx; ?></h3>
<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'uzytkownik-zlecenia-rozwiazane-lista-kl-'.$indx,
	'dataProvider'=> new CArrayDataProvider($rozw, array(
		'pagination'=>array(
			'pageSize'=>3))),
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'header'=>'Id zlecenia',
			'name'=>'zlecenie',
			'type'=>'raw',
//			'value'=>'$data->idZlecenia'
			'value'=>'"<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/update", array("id"=>$data->idZlecenia)) . "\">$data->idZlecenia</a>"'
		),
		array(
			'header'=>'Dziedzina',
			'name'=>'dziedzina',
			'value'=>'"<img title=\"" . $data->idZlecenia0->dziedzina->nazwa . "\" alt=\"" . $data->idZlecenia0->dziedzina->nazwa .
				"\" src=\"" . $data->idZlecenia0->dziedzina->namesAsImageUrl . "\" />"',
			'type'=>'raw'
		),
		array(
			'header'=>'Kategoria',
			'name'=>'kategoria',
			'value'=>'$data->idZlecenia0->kategoria',
		),
		array(
			'header'=>'Poziom',
			'name'=>'poziom',
			'value'=>'$data->idZlecenia0->poziomStr',
		),
		array(
			'header'=>'Data',
			'name'=>'czasZakonczenia',
			'value'=>'$data->czasZakonczenia',
		),
		array(
			'header'=>'Użytkownik',
			'name'=>'user',
			'value'=>'$data->uczen["imie"]. " " .$data->uczen["nazwisko"]',
		),
		array(
			'header'=>'Firma',
			'name'=>'firma',
			'value'=>'$data->idFirmy0["nazwa"]',
		),
		array(
			'header'=>'Akcje',
			'value'=>'"<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/ignoreReportedSolution", array("id"=>$data->id)) . "\" class=\"buttonS bDefault\">Ignoruj</a><br/>
				<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/resetReportedSolution", array("id"=>$data->id)) . "\" class=\"buttonS bDefault\">Zresetuj zadanie</a><br/>
				<a href=\"" . Yii::app()->CreateUrl("/administration/zlecenie/acceptReportedSolution", array("id"=>$data->id)) . "\" class=\"buttonS bDefault\">Uznaj odpowiedź</a>
</td></tr><tr><td colspan=\"9\"><div header-id=\"" . $data->id ."\">Szczegóły</div><div tresc-id=\"" . $data->id ."\">" .
				(empty($data->idZlecenia0->urlObrazka) ? "" :
				"<h1><img src=\"" . Yii::app()->baseUrl."/".$data->idZlecenia0->urlObrazka . "\"/></h1>") .
				"<p>" . $data->idZlecenia0->tresc . "</p>
				<div><u>Odpowiedzi</u>: " . implode(", ", array_values(CHtml::listData($data->idZlecenia0->odpowiedziZlecenia, "id", "odpowiedz"))) . "</div>
				<div><u>Udzielona odpowiedź</u>: <i>" . ($data->odpowiedz == null ? "brak odpowiedzi" : $data->odpowiedz) .
					($data->idZlecenia0->jednostka==null?"":" [".$data->idZlecenia0->jednostka."]") . "</i></div>
				<div><u>Szkoła</u>: ". $data->uczen->klasa->szkola["nazwa"]."</div>
				</div></td></tr>
				"',
			'type'=>'raw'
		),
	),
));
?>
<br/><br/>
<?php endforeach; ?>
<?php */ ?>
<?php if(Yii::app()->user->role !== 'schoolAdmin'): ?>
<h2>Rozwiązane zlecenia pogrupowane według szkół</h2>
<?php echo "<div id='accordion'>";

foreach($klasySzkoly as $idSzkoly=>$klasy)
{
	echo '<h3>Zlecenia szkoły: '. $nazwySzkol[$idSzkoly] .'</h3><div>';
	foreach($klasy as $klasa)
	{
		echo '<a href="'. $this->createUrl("/administration/zlecenie/solutionsClass", array("id"=>$klasa[0])) . '"><div class="class-row">Rozwiązane zlecenia klasy ' . $klasa[1] . '</div></a>';
	}
	echo '</div>';

}
echo '</div>'; ?>
<?php endif; ?>
</div>
